/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.accessor;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Accessor;
import org.databene.commons.accessor.DependentAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorCache<C, V>
implements DependentAccessor<C, V> {
    private String name;
    private Accessor<C, V> realAccessor;
    private V cachedValue;
    private boolean valid;

    public AccessorCache(String name, Accessor<C, V> realAccessor) {
        this.realAccessor = realAccessor;
        this.name = name;
        this.valid = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public V getValue(C item) {
        if (!this.valid) {
            this.cachedValue = this.realAccessor.getValue(item);
            this.valid = true;
        }
        return this.cachedValue;
    }

    @Override
    public List<? extends Accessor> getDependencies() {
        if (this.realAccessor instanceof DependentAccessor) {
            return ((DependentAccessor)this.realAccessor).getDependencies();
        }
        return new ArrayList();
    }
}

