/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.accessor;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Accessor;
import org.databene.commons.BeanUtil;
import org.databene.commons.Composite;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureAccessor<C, V>
implements Accessor<C, V> {
    private static Log logger = LogFactory.getLog(FeatureAccessor.class);
    private static Escalator escalator = new LoggerEscalator();
    private String featureName;

    public FeatureAccessor(String featureName) {
        this(featureName, true);
    }

    public FeatureAccessor(String featureName, boolean strict) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FeatureAccessor(" + featureName + ", " + strict + ")"));
        }
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public V getValue(C target) {
        return (V)FeatureAccessor.getValue(target, this.featureName);
    }

    public static Object getValue(Object target, String featureName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getValue(" + target + ", " + featureName + ")"));
        }
        return FeatureAccessor.getValue(target, featureName, true);
    }

    public static Object getValue(Object target, String featureName, boolean strict) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return ((Map)target).get(featureName);
        }
        if (target instanceof Context) {
            return ((Context)target).get(featureName);
        }
        if (target instanceof Composite) {
            return ((Composite)target).getComponent(featureName);
        }
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(target.getClass(), featureName);
        if (propertyDescriptor != null) {
            try {
                return propertyDescriptor.getReadMethod().invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new ConfigurationError("Unable to access feature '" + featureName + "'", e);
            }
        }
        if (strict) {
            throw new UnsupportedOperationException(target.getClass() + " does not support a feature '" + featureName + "'");
        }
        escalator.escalate("Feature '" + featureName + "' not found in object " + target, FeatureAccessor.class, null);
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.featureName + ']';
    }
}

