/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.lang.reflect.Array;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyAccessorFactory;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPropertyExtractor<E>
extends FixedSourceTypeConverter<Object[], E[]> {
    private String propertyName;
    private Class<E> propertyType;

    public ArrayPropertyExtractor(String propertyName, Class<E> propertyType) {
        super(Object[].class, ArrayUtil.arrayType(propertyType));
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    @Override
    public E[] convert(Object[] sourceValue) throws ConversionException {
        return ArrayPropertyExtractor.convert(sourceValue, this.propertyName, this.propertyType);
    }

    public static <T> T[] convert(Object[] sourceValue, String propertyName, Class<T> propertyType) throws ConversionException {
        Object[] array = (Object[])Array.newInstance(propertyType, sourceValue.length);
        PropertyAccessor propertyAccessor = PropertyAccessorFactory.getAccessor(propertyName);
        for (int i = 0; i < sourceValue.length; ++i) {
            Object value = propertyAccessor.getValue(sourceValue[i]);
            array[i] = AnyConverter.convert(value, propertyType);
        }
        return array;
    }
}

