/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.util.Comparator;
import org.databene.commons.ComparableComparator;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyAccessorFactory;
import org.databene.commons.comparator.ComparatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanComparator<C, V>
implements Comparator<C> {
    private Comparator<V> beanComparator;
    private PropertyAccessor<C, V> propertyAccessor;

    public BeanComparator(String propertyName) {
        this.beanComparator = new ComparableComparator<V>();
        try {
            this.propertyAccessor = PropertyAccessorFactory.getAccessor(propertyName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BeanComparator(Class comparedClass, String propertyName) {
        this(comparedClass, propertyName, BeanComparator.getComparator(comparedClass, propertyName));
    }

    public BeanComparator(Class comparedClass, String propertyName, Comparator<V> comparator) {
        this.beanComparator = comparator;
        try {
            this.propertyAccessor = PropertyAccessorFactory.getAccessor(comparedClass, propertyName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compare(C o1, C o2) {
        try {
            Object v1 = this.propertyAccessor.getValue(o1);
            Object v2 = this.propertyAccessor.getValue(o2);
            return this.beanComparator.compare(v1, v2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Comparator<T> getComparator(Class<T> comparedClass, String propertyName) {
        PropertyAccessor propertyAccessor = PropertyAccessorFactory.getAccessor(comparedClass, propertyName);
        Comparator beanComparator = ComparatorFactory.getComparator(propertyAccessor.getValueType());
        if (beanComparator == null) {
            throw new IllegalArgumentException("Property '" + comparedClass.getName() + '.' + propertyName + "' " + "is expected to implement Comparable");
        }
        return beanComparator;
    }
}

