/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.bean.DefaultClassProvider;
import org.databene.commons.bean.PropertyMutator;
import org.databene.commons.bean.PropertyMutatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFactory {
    private static final ClassProvider DEFAULT_CLASS_PROVIDER = new DefaultClassProvider();

    public static Object newBean(String beanClassName, Map<String, Object> properties) {
        return BeanFactory.newBean(beanClassName, properties, DEFAULT_CLASS_PROVIDER);
    }

    public static Object newBean(String beanClassName, Map<String, Object> properties, ClassProvider factory) {
        Object bean = BeanUtil.newInstance(factory.forName(beanClassName), new Object[0]);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            PropertyMutator mutator = PropertyMutatorFactory.getPropertyMutator(bean.getClass(), propertyName, false);
            try {
                mutator.setValue(bean, entry.getValue());
            }
            catch (UpdateFailedException e) {
                throw new RuntimeException("Unable to set property " + propertyName + " on class " + beanClassName, e);
            }
        }
        return bean;
    }
}

