/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import org.databene.commons.ConversionException;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyAccessorFactory;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToPropertyArrayConverter<E>
extends FixedSourceTypeConverter<E, Object[]> {
    private PropertyAccessor<E, ? extends Object>[] accessors;

    public BeanToPropertyArrayConverter(String ... propertyNames) {
        this((Class<E>)null, propertyNames);
    }

    public BeanToPropertyArrayConverter(Class<E> beanClass, String ... propertyNames) {
        super(beanClass, Object[].class);
        this.accessors = new PropertyAccessor[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.accessors[i] = PropertyAccessorFactory.getAccessor(beanClass, propertyNames[i]);
        }
    }

    @Override
    public Object[] convert(E bean) throws ConversionException {
        Object[] propertyValues = new Object[this.accessors.length];
        for (int i = 0; i < this.accessors.length; ++i) {
            propertyValues[i] = this.accessors[i].getValue(bean);
        }
        return propertyValues;
    }
}

