/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;

public class ClassCache {
    private static final Log logger = LogFactory.getLog(ClassCache.class);
    private Map<String, Class> classes = new HashMap<String, Class>();
    private Set<String> packages = new HashSet<String>();

    public ClassCache() {
        this.importPackage("java.lang");
    }

    public void importClass(String className) {
        if ((className = className.trim()).endsWith(".*")) {
            this.importPackage(className.substring(0, className.length() - 2));
        } else {
            this.classes.put(StringUtil.lastToken(className, '.'), BeanUtil.forName(className));
        }
    }

    public void importPackage(String packageName) {
        this.packages.add(packageName);
    }

    public Class forName(String name) {
        Class result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        try {
            result = BeanUtil.forName(name);
            this.classes.put(result.getSimpleName(), result);
            return result;
        }
        catch (ConfigurationError e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("class not found: " + name));
            }
            for (String pkg : this.packages) {
                try {
                    result = BeanUtil.forName(pkg + '.' + name);
                    this.classes.put(result.getSimpleName(), result);
                    return result;
                }
                catch (ConfigurationError e2) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("class not found: " + name));
                }
            }
            throw new ConfigurationError("Class not found: " + name);
        }
    }
}

