/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ArrayUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.commons.bean.ObservableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableFactory {
    public static <E extends ObservableBean> E create(Class<E> type) {
        if (!type.isInterface()) {
            throw new ConfigurationError("Not an interface: " + type);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ObservableBeanInvocationHandler<E> handler = new ObservableBeanInvocationHandler<E>(type);
        ObservableBean bean = (ObservableBean)Proxy.newProxyInstance(classLoader, new Class[]{type}, handler);
        return (E)bean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObservableBeanInvocationHandler<E>
    implements InvocationHandler {
        private Map<String, Object> propertyValues = new HashMap<String, Object>();
        private PropertyChangeSupport support;
        private Class<E> type;

        public ObservableBeanInvocationHandler(Class<E> type) {
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (this.support == null) {
                this.support = new PropertyChangeSupport(proxy);
            }
            if ((methodName = method.getName()).startsWith("get") && ArrayUtil.isEmpty(args)) {
                String propertyName = methodName.substring(3);
                propertyName = StringUtil.uncapitalize(propertyName);
                return this.propertyValues.get(propertyName);
            }
            if (methodName.startsWith("set")) {
                String propertyName = methodName.substring(3);
                propertyName = StringUtil.uncapitalize(propertyName);
                Object oldValue = this.propertyValues.get(propertyName);
                this.propertyValues.put(propertyName, args[0]);
                this.support.firePropertyChange(propertyName, oldValue, args[0]);
            } else if ("addPropertyChangeListener".equals(methodName)) {
                if (args.length == 2) {
                    this.support.addPropertyChangeListener((String)args[0], (PropertyChangeListener)args[1]);
                } else {
                    this.support.addPropertyChangeListener((PropertyChangeListener)args[0]);
                }
            } else if ("removePropertyChangeListener".equals(methodName)) {
                if (args.length == 2) {
                    this.support.removePropertyChangeListener((String)args[0], (PropertyChangeListener)args[1]);
                } else {
                    this.support.removePropertyChangeListener((PropertyChangeListener)args[0]);
                }
            } else {
                if ("equals".equals(methodName)) {
                    Object other = args[0];
                    if (proxy == other) {
                        return true;
                    }
                    if (other == null) {
                        return false;
                    }
                    if (!proxy.getClass().equals(other.getClass())) {
                        return false;
                    }
                    ObservableBeanInvocationHandler otherHandler = (ObservableBeanInvocationHandler)Proxy.getInvocationHandler(proxy);
                    return ((Object)this.propertyValues).equals(otherHandler.propertyValues);
                }
                if ("hashCode".equals(methodName)) {
                    return ((Object)this.propertyValues).hashCode();
                }
                if ("toString".equals(methodName)) {
                    return this.type.getName() + this.propertyValues;
                }
                throw new UnsupportedOperationException("Operation not supported: " + method);
            }
            return null;
        }
    }
}

