/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.util.Map;
import java.util.Properties;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.PropertyMutator;
import org.databene.commons.bean.PropertyMutatorFactory;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties2BeanConverter<E>
extends FixedSourceTypeConverter<Properties, E> {
    public Properties2BeanConverter(Class<E> beanClass) {
        super(Properties.class, beanClass);
    }

    @Override
    public E convert(Properties sourceValue) throws ConversionException {
        return (E)Properties2BeanConverter.convert(sourceValue, this.targetType);
    }

    public static <T> T convert(Properties props, Class<T> targetClass) throws ConversionException {
        try {
            T bean = BeanUtil.newInstance(targetClass, new Object[0]);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                if ("class".equals(propertyName)) continue;
                PropertyMutator propertyMutator = PropertyMutatorFactory.getPropertyMutator(targetClass, propertyName, false);
                propertyMutator.setValue(bean, entry.getValue());
            }
            return bean;
        }
        catch (UpdateFailedException e) {
            throw new ConversionException(e);
        }
    }
}

