/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyDescriptor;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyGraphAccessor;
import org.databene.commons.bean.TypedPropertyAccessor;
import org.databene.commons.bean.UntypedPropertyAccessor;

public class PropertyAccessorFactory {
    private PropertyAccessorFactory() {
    }

    public static PropertyAccessor getAccessor(String propertyName) {
        return PropertyAccessorFactory.getAccessor(null, propertyName);
    }

    public static PropertyAccessor getAccessor(String propertyName, boolean strict) {
        return PropertyAccessorFactory.getAccessor(null, propertyName, strict);
    }

    public static PropertyAccessor getAccessor(Class beanClass, String propertyName) {
        return PropertyAccessorFactory.getAccessor(beanClass, propertyName, true);
    }

    public static PropertyAccessor getAccessor(Class beanClass, String propertyName, boolean strict) {
        PropertyDescriptor propertyDescriptor;
        if (beanClass != null && (propertyDescriptor = BeanUtil.getPropertyDescriptor(beanClass, propertyName)) == null && strict) {
            throw new ConfigurationError("No property '" + propertyName + "' found in " + beanClass);
        }
        int index = propertyName.indexOf(46);
        if (index < 0) {
            if (beanClass == null) {
                return new UntypedPropertyAccessor(propertyName, strict);
            }
            return new TypedPropertyAccessor(beanClass, propertyName, strict);
        }
        return new PropertyGraphAccessor(beanClass, propertyName, strict);
    }
}

