/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import org.databene.commons.StringUtil;
import org.databene.commons.accessor.TypedAccessor;
import org.databene.commons.accessor.TypedAccessorChain;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyAccessorFactory;

class PropertyGraphAccessor
extends TypedAccessorChain
implements PropertyAccessor {
    private String propertyName;

    public PropertyGraphAccessor(Class beanClass, String propertyName, boolean strict) {
        super(PropertyGraphAccessor.createSubAccessors(beanClass, propertyName, strict));
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    private static TypedAccessor[] createSubAccessors(Class beanClass, String propertyName, boolean strict) {
        String[] nodeNames = StringUtil.tokenize(propertyName, '.');
        TypedAccessor[] nodes = new PropertyAccessor[nodeNames.length];
        Class intermediateClass = beanClass;
        for (int i = 0; i < nodeNames.length; ++i) {
            PropertyAccessor node = PropertyAccessorFactory.getAccessor(intermediateClass, nodeNames[i], strict);
            nodes[i] = node;
            if (intermediateClass == null) continue;
            intermediateClass = node.getValueType();
        }
        return nodes;
    }
}

