/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.PropertyAccessor;
import org.databene.commons.bean.PropertyAccessorFactory;
import org.databene.commons.bean.PropertyMutator;
import org.databene.commons.bean.PropertyMutatorFactory;
import org.databene.commons.bean.TypedPropertyMutator;
import org.databene.commons.bean.UntypedPropertyMutator;

class PropertyGraphMutator
implements PropertyMutator {
    private static Log logger = LogFactory.getLog(PropertyGraphMutator.class);
    private boolean strict;
    private PropertyAccessor[] subAccessors;
    private PropertyMutator lastMutator;
    private String propertyName;

    public PropertyGraphMutator(String propertyName) {
        this(propertyName, true);
    }

    public PropertyGraphMutator(String propertyName, boolean strict) {
        this(null, propertyName, strict);
    }

    public PropertyGraphMutator(Class beanClass, String propertyName) {
        this(beanClass, propertyName, true);
    }

    public PropertyGraphMutator(Class beanClass, String propertyName, boolean strict) {
        this.propertyName = propertyName;
        this.strict = strict;
        int separatorIndex = propertyName.indexOf(46);
        if (separatorIndex >= 0) {
            String[] nodeNames = StringUtil.tokenize(propertyName, '.');
            Class nodeClass = beanClass;
            this.subAccessors = new PropertyAccessor[nodeNames.length - 1];
            for (int i = 0; i < nodeNames.length - 1; ++i) {
                this.subAccessors[i] = PropertyAccessorFactory.getAccessor(nodeClass, nodeNames[i], strict);
                nodeClass = this.subAccessors[i].getValueType();
            }
            String lastNodeName = nodeNames[nodeNames.length - 1];
            this.lastMutator = beanClass != null ? PropertyMutatorFactory.getPropertyMutator(this.subAccessors[this.subAccessors.length - 1].getValueType(), lastNodeName, strict) : new UntypedPropertyMutator(lastNodeName, strict);
        } else {
            this.lastMutator = new TypedPropertyMutator(beanClass, propertyName, strict);
        }
    }

    public String getName() {
        return this.propertyName;
    }

    public void setValue(Object bean, Object propertyValue) throws UpdateFailedException {
        if (bean == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Cannot set a property on null");
            }
            return;
        }
        logger.debug((Object)("setting property '" + this.getName() + "' to '" + propertyValue + "' on bean " + bean));
        Object superBean = bean;
        if (this.subAccessors != null) {
            for (PropertyAccessor subAccessor : this.subAccessors) {
                Object subBean = subAccessor.getValue(superBean);
                if (subBean == null && propertyValue != null) {
                    Class propertyType = subAccessor.getValueType();
                    subBean = BeanUtil.newInstance(propertyType, new Object[0]);
                    BeanUtil.setPropertyValue(superBean, subAccessor.getPropertyName(), subBean);
                }
                superBean = subBean;
            }
        }
        this.lastMutator.setValue(superBean, propertyValue);
    }
}

