/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.bean.PropertyAccessor;

class TypedPropertyAccessor
implements PropertyAccessor {
    private String propertyName;
    private Method accessorMethod;
    private boolean strict;

    public TypedPropertyAccessor(Class beanClass, String propertyName, boolean strict) {
        this.propertyName = propertyName;
        this.strict = strict;
        try {
            PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(beanClass, propertyName);
            if (propertyDescriptor == null) {
                if (strict) {
                    throw new ConfigurationError("No property '" + propertyName + "' found in " + beanClass);
                }
            } else {
                this.accessorMethod = propertyDescriptor.getReadMethod();
                if (this.accessorMethod == null) {
                    throw new ConfigurationError("No read method for property '" + propertyName + "'" + " found on " + beanClass);
                }
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getValue(Object object) {
        if (object == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Trying to get property value '" + this.propertyName + "' from null");
            }
            return null;
        }
        try {
            return this.accessorMethod != null ? this.accessorMethod.invoke(object, new Object[0]) : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class getValueType() {
        return this.accessorMethod != null ? this.accessorMethod.getReturnType() : null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

