/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConversionException;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.AbstractPropertyMutator;
import org.databene.commons.converter.AnyConverter;

public class TypedPropertyMutator
extends AbstractPropertyMutator {
    private boolean strict;
    private Method writeMethod;

    public TypedPropertyMutator(Class beanClass, String propertyName, boolean strict) {
        super(propertyName);
        this.strict = strict;
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(beanClass, propertyName);
        if (propertyDescriptor == null) {
            if (strict) {
                throw new ConfigurationError("No property '" + propertyName + "' found in " + beanClass);
            }
            this.writeMethod = null;
        } else {
            this.writeMethod = propertyDescriptor.getWriteMethod();
            if (this.writeMethod == null) {
                throw new ConfigurationError("No write method found for property '" + propertyName + "'");
            }
        }
    }

    public void setValue(Object bean, Object value) throws UpdateFailedException {
        if (bean == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Cannot set a property on null");
            }
            return;
        }
        this.setValue(bean, value, this.strict);
    }

    public void setValue(Object target, Object propertyValue, boolean strict) {
        if (this.writeMethod == null) {
            return;
        }
        if (!strict && propertyValue != null) {
            Class<?> sourceType = propertyValue.getClass();
            Class<?> targetType = this.writeMethod.getParameterTypes()[0];
            try {
                if (!targetType.isAssignableFrom(sourceType)) {
                    propertyValue = AnyConverter.convert(propertyValue, targetType);
                }
            }
            catch (ConversionException e) {
                throw new ConfigurationError(e);
            }
        }
        BeanUtil.invoke(target, this.writeMethod, propertyValue);
    }
}

