/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyDescriptor;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.bean.PropertyAccessor;

class UntypedPropertyAccessor
implements PropertyAccessor {
    private String propertyName;
    private Class propertyType;
    private boolean strict;

    public UntypedPropertyAccessor(String propertyName, boolean strict) {
        this.propertyName = propertyName;
        this.propertyType = Object.class;
        this.strict = strict;
    }

    public Object getValue(Object bean) {
        if (bean == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Trying to get property value '" + this.propertyName + "' from null");
            }
            return null;
        }
        PropertyDescriptor descriptor = BeanUtil.getPropertyDescriptor(bean.getClass(), this.propertyName);
        if (descriptor == null) {
            if (this.strict) {
                throw new ConfigurationError("No property '" + this.propertyName + "' found in class " + bean.getClass());
            }
            return null;
        }
        this.propertyType = descriptor.getPropertyType();
        return BeanUtil.invoke(bean, descriptor.getReadMethod(), new Object[0]);
    }

    public Class getValueType() {
        return this.propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

