/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConversionException;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.bean.AbstractPropertyMutator;
import org.databene.commons.converter.AnyConverter;

public class UntypedPropertyMutator
extends AbstractPropertyMutator {
    private boolean strict;

    public UntypedPropertyMutator(String propertyName, boolean strict) {
        super(propertyName);
        this.strict = strict;
    }

    public void setValue(Object target, Object value) throws UpdateFailedException {
        this.setValue(target, value, this.strict);
    }

    public void setValue(Object bean, Object propertyValue, boolean strict) throws UpdateFailedException {
        if (bean == null) {
            if (strict) {
                throw new UpdateFailedException("Cannot set a property on a null pointer");
            }
            return;
        }
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(bean.getClass(), this.name);
        if (propertyDescriptor == null) {
            if (strict) {
                throw new UpdateFailedException("property '" + this.name + "' not found in class " + bean.getClass());
            }
            return;
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod == null) {
            if (strict) {
                throw new UpdateFailedException("No write method found for property '" + this.name + "' in class " + bean.getClass());
            }
            return;
        }
        if (!strict && propertyValue != null) {
            Class<?> sourceType = propertyValue.getClass();
            Class<?> targetType = writeMethod.getParameterTypes()[0];
            try {
                if (!targetType.isAssignableFrom(sourceType)) {
                    propertyValue = AnyConverter.convert(propertyValue, targetType);
                }
            }
            catch (ConversionException e) {
                throw new ConfigurationError(e);
            }
        }
        BeanUtil.invoke(bean, writeMethod, propertyValue);
    }
}

