/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBasedSet<E>
implements Set<E> {
    private List<E> list;

    public ListBasedSet() {
        this.list = new ArrayList();
    }

    public ListBasedSet(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public ListBasedSet(Collection<E> collection) {
        this.list = new ArrayList<E>(collection);
    }

    public ListBasedSet(E ... elements) {
        this.list = new ArrayList(elements.length);
        for (E element : elements) {
            this.list.add(element);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E o) {
        if (this.list.contains(o)) {
            return true;
        }
        return this.list.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public E get(int index) {
        return this.list.get(index);
    }

    public String toString() {
        return this.list.toString();
    }
}

