/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.databene.commons.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedValueList<E> {
    public static final int SENSITIVE = 0;
    public static final int INSENSITIVE = 1;
    public static final int IGNORANT = 2;
    private int caseHandling;
    private List<String> names = new ArrayList<String>();
    private List<E> values = new ArrayList();
    private Map<String, Integer> indices = new HashMap<String, Integer>();

    public static <T> NamedValueList<T> createCaseSensitiveList() {
        return new NamedValueList(0);
    }

    public static <T> NamedValueList<T> createCaseInsensitiveList() {
        return new NamedValueList(1);
    }

    public static <T> NamedValueList<T> createCaseIgnorantList() {
        return new NamedValueList(2);
    }

    public NamedValueList() {
        this(0);
    }

    public NamedValueList(int caseHandling) {
        this.caseHandling = caseHandling;
    }

    public int size() {
        return this.values.size();
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public boolean containsName(String name) {
        boolean contained;
        if (this.caseHandling == 2 && name != null) {
            name = name.toLowerCase();
        }
        if ((contained = this.indices.containsKey(name)) || this.caseHandling == 2 || this.caseHandling == 0 || name == null) {
            return contained;
        }
        for (String nameCandidate : this.names) {
            if (!StringUtil.equalsIgnoreCase(nameCandidate, name)) continue;
            return true;
        }
        return false;
    }

    public E getValue(int index) {
        return this.values.get(index);
    }

    public void set(String name, E value) {
        int index;
        if (StringUtil.isEmpty(name)) {
            this.add(name, value);
        }
        if (this.caseHandling == 2) {
            name = name.toLowerCase();
        }
        if ((index = this.someIndexOfName(name)) < 0) {
            this.add(name, value);
        } else {
            this.setValue(index, value);
        }
    }

    public void add(String name, E value) {
        if (this.caseHandling == 2 && name != null) {
            name = name.toLowerCase();
        }
        this.names.add(name);
        this.values.add(value);
        this.indices.put(name, this.values.size() - 1);
    }

    public void setValue(int index, E value) {
        this.values.set(index, value);
    }

    public E someValueOfName(String name) {
        int index = this.someIndexOfName(name);
        return index >= 0 ? (E)this.getValue(index) : null;
    }

    public int someIndexOfName(String name) {
        Integer index;
        if (this.caseHandling == 2 && name != null) {
            name = name.toLowerCase();
        }
        if ((index = this.indices.get(name)) != null) {
            return index;
        }
        if (this.caseHandling == 2 || this.caseHandling == 0) {
            return -1;
        }
        for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
            if (!StringUtil.equalsIgnoreCase(entry.getKey(), name)) continue;
            return entry.getValue();
        }
        return -1;
    }

    public void clear() {
        this.names.clear();
        this.values.clear();
        this.indices.clear();
    }

    public List<String> names() {
        return Collections.unmodifiableList(this.names);
    }

    public List<E> values() {
        return Collections.unmodifiableList(this.values);
    }

    public String toString() {
        return this.values.toString();
    }
}

