/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.collection;

import java.util.Map;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.OrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedNameMap<E>
extends OrderedMap<String, E> {
    private static final int CASE_SENSITIVE = 0;
    private static final int CASE_INSENSITIVE = 1;
    private static final int CASE_IGNORANT = 2;
    private int caseSupport;

    public OrderedNameMap() {
        this(0);
    }

    public static <T> OrderedNameMap<T> createCaseSensitiveMap() {
        return new OrderedNameMap();
    }

    public static <T> OrderedNameMap<T> createCaseInsensitiveMap() {
        return new OrderedNameMap(1);
    }

    public static <T> OrderedNameMap<T> createCaseIgnorantMap() {
        return new OrderedNameMap(2);
    }

    private OrderedNameMap(int caseSupport) {
        this.caseSupport = caseSupport;
    }

    public boolean containsKey(String key) {
        boolean result = super.containsKey(this.normalizeKey(key));
        if (result || this.caseSupport == 0) {
            return result;
        }
        for (String tmp : super.keySet()) {
            if (!tmp.equalsIgnoreCase(key)) continue;
            return true;
        }
        return result;
    }

    public E get(String key) {
        Object result = super.get(this.normalizeKey(key));
        if (result != null || this.caseSupport == 0) {
            return (E)result;
        }
        for (Map.Entry entry : super.entrySet()) {
            String tmp = (String)entry.getKey();
            if ((tmp != null || key != null) && (tmp == null || !tmp.equalsIgnoreCase(key))) continue;
            return (E)entry.getValue();
        }
        return (E)result;
    }

    @Override
    public E put(String key, E value) {
        return super.put(this.normalizeKey(key), value);
    }

    public E remove(String key) {
        Object result = super.remove(this.normalizeKey(key));
        if (result != null || this.caseSupport != 1) {
            return (E)result;
        }
        for (Map.Entry entry : super.entrySet()) {
            if (!NullSafeComparator.equals(entry.getKey(), key)) continue;
            return (E)super.remove(entry.getKey());
        }
        return null;
    }

    private String normalizeKey(String key) {
        return this.caseSupport == 2 && key != null ? key.toLowerCase() : key;
    }
}

