/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.comparator;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ComparableComparator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorFactory {
    private static final Log logger = LogFactory.getLog(ComparatorFactory.class);
    private static final String CONFIG_FILE_URI = "org/databene/commons/comparator/comparators.txt";
    private static Map<Class<? extends Object>, Comparator<? extends Object>> comparators = new HashMap<Class<? extends Object>, Comparator<? extends Object>>();

    public static void addComparator(Class comparedClass, Comparator comparator) {
        comparators.put(comparedClass, comparator);
    }

    private static void readConfigFileIfExists(String uri) {
        if (!IOUtil.isURIAvailable(uri)) {
            logger.info((Object)("No custom Comparator setup defined, (" + uri + "), using defaults"));
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = IOUtil.getReaderForURI(uri);
            while ((line = reader.readLine()) != null) {
                if (StringUtil.isEmpty(line = line.trim())) continue;
                ComparatorFactory.createComparator(line);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError(e);
        }
        finally {
            IOUtil.close(reader);
        }
    }

    private static <T> Comparator<T> createComparator(String className) {
        Class cls = BeanUtil.forName(className);
        Comparator comparator = (Comparator)BeanUtil.newInstance(cls, new Object[0]);
        Type[] genTypes = BeanUtil.getGenericInterfaceParams(cls, Comparator.class);
        ComparatorFactory.addComparator((Class)genTypes[0], comparator);
        return comparator;
    }

    public static <T> Comparator<T> getComparator(Class<T> type) {
        Comparator<? extends Object> comparator = comparators.get(type);
        if (comparator == null && Comparable.class.isAssignableFrom(type)) {
            comparator = new ComparableComparator<Object>();
        }
        if (comparator == null) {
            throw new RuntimeException("No Comparator defined for " + type.getName());
        }
        return new NullSafeComparator(comparator);
    }

    static {
        ComparatorFactory.addComparator(String.class, Collator.getInstance());
        ComparatorFactory.readConfigFileIfExists(CONFIG_FILE_URI);
        ComparatorFactory.addComparator(Comparable.class, new ComparableComparator());
    }
}

