/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.comparator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberComparator<T extends Number>
implements Comparator<T> {
    @Override
    public int compare(T n1, T n2) {
        if (n1 == null || n2 == null) {
            throw new IllegalArgumentException("comparing null value");
        }
        if (n1 instanceof Integer) {
            return ((Integer)n1).compareTo(((Number)n2).intValue());
        }
        if (n1 instanceof Long) {
            return ((Long)n1).compareTo(((Number)n2).longValue());
        }
        if (n1 instanceof Short) {
            return ((Short)n1).compareTo(((Number)n2).shortValue());
        }
        if (n1 instanceof Byte) {
            return ((Byte)n1).compareTo(((Number)n2).byteValue());
        }
        if (n1 instanceof Float) {
            return ((Float)n1).compareTo(Float.valueOf(((Number)n2).floatValue()));
        }
        if (n1 instanceof Double) {
            return ((Double)n1).compareTo(((Number)n2).doubleValue());
        }
        if (n1 instanceof BigInteger) {
            return ((BigInteger)n1).compareTo((BigInteger)n2);
        }
        if (n1 instanceof BigDecimal) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2);
        }
        throw new UnsupportedOperationException("Unsupported Number type: " + n1.getClass());
    }
}

