/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.condition;

import java.util.Comparator;
import org.databene.commons.ComparableComparator;
import org.databene.commons.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparationCondition<E>
implements Condition<E[]> {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int GREATER_OR_EQUAL = 2;
    public static final int GREATER = 3;
    public static final int LESS_OR_EQUAL = 4;
    public static final int LESS = 5;
    private int operator;
    private Comparator comparator;

    public ComparationCondition() {
        this(0);
    }

    public ComparationCondition(int operator) {
        this(operator, new ComparableComparator());
    }

    public ComparationCondition(int operator, Comparator comparator) {
        this.operator = operator;
        this.comparator = comparator;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean evaluate(E[] arguments) {
        if (arguments.length != 2) {
            throw new IllegalArgumentException("Comparation only supported for two arguments, found: " + arguments.length);
        }
        int comparation = this.comparator.compare(arguments[0], arguments[1]);
        switch (this.operator) {
            case 0: {
                return comparation == 0;
            }
            case 1: {
                return comparation != 0;
            }
            case 2: {
                return comparation >= 0;
            }
            case 3: {
                return comparation == 1;
            }
            case 4: {
                return comparation <= 0;
            }
            case 5: {
                return comparation == -1;
            }
        }
        throw new IllegalStateException("Operator no supported: " + this.operator);
    }
}

