/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.databene.commons.CollectionUtil;
import org.databene.commons.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveContext
implements Context {
    private boolean capsPreserved;
    private Map<String, Object> map;

    public CaseInsensitiveContext(boolean capsPreserved) {
        this.capsPreserved = capsPreserved;
        this.map = new HashMap<String, Object>();
    }

    @Override
    public synchronized void set(String key, Object value) {
        this.map.put(this.transformKey(key), value);
    }

    @Override
    public synchronized Object get(String key) {
        return CollectionUtil.getCaseInsensitive(this.transformKey(key), this.map);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void remove(String key) {
        this.map.remove(this.transformKey(key));
    }

    private String transformKey(String key) {
        if (!this.capsPreserved) {
            key = key.toUpperCase();
        }
        return key;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.map;
    }
}

