/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.context;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStack
implements Context {
    private static final Log logger = LogFactory.getLog(ContextStack.class);
    protected Stack<Context> contexts = new Stack();

    public ContextStack(Context ... contexts) {
        for (Context c : contexts) {
            this.contexts.push(c);
        }
    }

    @Override
    public synchronized Object get(String key) {
        for (int i = this.contexts.size() - 1; i >= 0; --i) {
            Context c = (Context)this.contexts.get(i);
            Object result = c.get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public synchronized Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (int i = this.contexts.size() - 1; i >= 0; --i) {
            Context c = (Context)this.contexts.get(i);
            keySet.addAll(c.keySet());
        }
        return keySet;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        for (int i = 0; i < this.contexts.size(); ++i) {
            Context c = (Context)this.contexts.get(i);
            entrySet.addAll(c.entrySet());
        }
        return entrySet;
    }

    @Override
    public synchronized void remove(String key) {
        if (this.contexts.size() > 0) {
            this.contexts.peek().remove(key);
        }
    }

    @Override
    public synchronized void set(String key, Object value) {
        if (this.contexts.size() > 0) {
            this.contexts.peek().set(key, value);
        } else {
            logger.warn((Object)("ContextStack is empty, ignoring element: " + key));
        }
    }

    public synchronized void push(Context context) {
        this.contexts.push(context);
    }

    public synchronized Context pop() {
        return this.contexts.pop();
    }
}

