/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.context;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Context;
import org.databene.commons.StringUtil;
import org.databene.commons.context.DefaultContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesContext
extends DefaultContext {
    private static Log logger = LogFactory.getLog(PropertiesContext.class);

    public PropertiesContext(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.set((String)entry.getKey(), entry.getValue());
        }
    }

    public PropertiesContext(Map<String, ? extends Object> map) {
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            this.set(name, value);
        }
    }

    @Override
    public void set(String name, Object value) {
        super.set(name, value);
        String[] tokens = StringUtil.tokenize(name, '.');
        if (tokens.length > 1) {
            Context node = this;
            for (int i = 0; i < tokens.length - 1; ++i) {
                String token = tokens[i];
                Object childObject = node.get(token);
                if (childObject != null && !(childObject instanceof Context)) {
                    if ("java.vendor.url.bug".equals(name) || "java.vendor.url".equals(name)) continue;
                    logger.warn((Object)("ignoring entry " + name + "=" + value));
                    continue;
                }
                Context childContext = (Context)childObject;
                if (childContext == null) {
                    childContext = new DefaultContext();
                    node.set(token, childContext);
                }
                node = childContext;
            }
            node.set(tokens[tokens.length - 1], value);
        }
    }
}

