/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.converter.AbstractConverter;
import org.databene.commons.converter.ConverterManager;
import org.databene.commons.converter.FactoryConverter;
import org.databene.commons.converter.NumberConverter;
import org.databene.commons.converter.StringConverter;
import org.databene.commons.converter.ToArrayConverter;
import org.databene.commons.converter.ToCollectionConverter;
import org.databene.commons.converter.ToStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyConverter<S, T>
extends AbstractConverter<S, T> {
    private static final Log logger = LogFactory.getLog(AnyConverter.class);
    private String datePattern;

    public AnyConverter(Class<T> targetType) {
        this(targetType, "yyyyMMdd");
    }

    public AnyConverter(Class<T> targetType, String datePattern) {
        super(targetType);
        this.datePattern = datePattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public boolean canConvert(Object sourceValue) {
        return true;
    }

    @Override
    public T convert(Object sourceValue) throws ConversionException {
        return (T)AnyConverter.convert(sourceValue, this.targetType, this.datePattern, null);
    }

    public static <TT> TT convert(Object source, Class<TT> targetType) throws ConversionException {
        return AnyConverter.convert(source, targetType, null, null);
    }

    public static <TT> TT convert(Object source, Class<TT> targetType, String datePattern, String timestampPattern) throws ConversionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converting " + source + (source != null ? " (" + source.getClass().getName() + ")" : "") + " to " + targetType));
        }
        if (targetType == null) {
            throw new ConversionException("targetType must be specified");
        }
        if (source == null) {
            return null;
        }
        if (targetType.isAssignableFrom(source.getClass()) && !targetType.isPrimitive()) {
            return (TT)source;
        }
        Converter converter = ConverterManager.getInstance().getConverter(source, targetType);
        if (converter != null) {
            return (TT)converter.convert(source);
        }
        if (String.class.equals(targetType)) {
            return (TT)ToStringConverter.convert(source, null, datePattern, timestampPattern, null);
        }
        if (String.class.equals(source.getClass())) {
            return StringConverter.convert((String)source, targetType);
        }
        if (source instanceof Number) {
            return NumberConverter.convert((Number)source, targetType);
        }
        if (source instanceof Boolean) {
            return AnyConverter.convertBoolean((Boolean)source, targetType);
        }
        if (targetType.isArray()) {
            return (TT)ToArrayConverter.convert(source, targetType.getComponentType());
        }
        if (Collection.class.isAssignableFrom(targetType)) {
            return (TT)ToCollectionConverter.convert(source, targetType);
        }
        return FactoryConverter.convert(source, targetType);
    }

    private static <TT> TT convertBoolean(Boolean src, Class<TT> targetType) {
        if (Boolean.TYPE.equals(targetType)) {
            return (TT)src;
        }
        if (Number.class.isAssignableFrom(targetType)) {
            return AnyConverter.convert(src != false ? 1 : 0, targetType);
        }
        if (Number.class.isAssignableFrom(BeanUtil.getWrapper(targetType.getName()))) {
            return AnyConverter.convert(src != false ? 1 : 0, targetType);
        }
        throw new UnsupportedOperationException("Don't know how to convert " + src.getClass() + " to " + targetType);
    }
}

