/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import org.databene.commons.ArrayUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter<S, T>
extends FixedSourceTypeConverter<S[], T[]> {
    private Class<T> componentType;
    private Converter<S, T>[] converters;

    public ArrayConverter(Class<S> sourceComponentType, Class<T> targetComponentType, Converter<S, T> ... converters) {
        super(ArrayUtil.arrayType(sourceComponentType), ArrayUtil.arrayType(targetComponentType));
        this.componentType = targetComponentType;
        this.converters = converters;
    }

    @Override
    public T[] convert(S[] sourceValues) throws ConversionException {
        if (sourceValues == null) {
            return null;
        }
        if (this.converters.length == 1) {
            return ArrayConverter.convert(sourceValues, this.converters[0], this.componentType);
        }
        T[] result = ArrayUtil.newInstance(this.componentType, this.converters.length);
        for (int i = 0; i < this.converters.length; ++i) {
            result[i] = this.converters[i].convert(sourceValues[i]);
        }
        return result;
    }

    public static <S, T> T[] convert(S[] sourceValues, Converter<S, T> converter, Class<T> componentType) throws ConversionException {
        T[] result = ArrayUtil.newInstance(componentType, sourceValues.length);
        for (int i = 0; i < sourceValues.length; ++i) {
            result[i] = converter != null ? converter.convert(sourceValues[i]) : sourceValues[i];
        }
        return result;
    }
}

