/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConverter<T>
extends FixedSourceTypeConverter<Boolean, T> {
    private T trueValue;
    private T falseValue;
    private T nullValue;

    public BooleanConverter() {
        this("true", "false", null);
    }

    public BooleanConverter(T trueValue, T falseValue, T nullValue) {
        super(Boolean.class, trueValue.getClass());
        this.trueValue = trueValue;
        this.falseValue = falseValue;
        this.nullValue = nullValue;
    }

    @Override
    public T convert(Boolean sourceValue) throws ConversionException {
        return sourceValue != null ? (sourceValue.booleanValue() ? this.trueValue : this.falseValue) : this.nullValue;
    }
}

