/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.ArrayList;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterChain<S, T>
implements Converter<S, T> {
    private ArrayList<Converter> converters;

    public ConverterChain(Converter ... converters) {
        this.converters = new ArrayList(converters.length);
        this.add(converters);
    }

    public void add(Converter ... converters) {
        CollectionUtil.add(this.converters, converters);
    }

    @Override
    public Class<T> getTargetType() {
        return this.converters.get(this.converters.size() - 1).getTargetType();
    }

    @Override
    public boolean canConvert(Object sourceValue) {
        return this.converters.get(0).canConvert(sourceValue);
    }

    @Override
    public T convert(S source) throws ConversionException {
        Object result = source;
        for (Converter converter : this.converters) {
            result = converter.convert(result);
        }
        return (T)result;
    }
}

