/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.converter.BidirectionalConverter;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.converter.ReverseConverter;

public class ConverterManager {
    private static final Log configLogger = LogFactory.getLog((String)"org.databene.CONFIG");
    private static final String DEFAULT_SETUP_FILENAME = "org/databene/commons/converter/converters.txt";
    private static final String CUSTOM_SETUP_FILENAME = "converters.txt";
    private static ConverterManager instance;
    private List<Converter> converters = new ArrayList<Converter>();

    public static ConverterManager getInstance() {
        if (instance == null) {
            instance = new ConverterManager();
        }
        return instance;
    }

    public Converter getConverter(Object sourceValue, Class dstType) {
        if (sourceValue == null) {
            return new NoOpConverter();
        }
        Class<?> srcType = sourceValue.getClass();
        if (srcType == dstType || dstType.isAssignableFrom(srcType) && !dstType.isPrimitive()) {
            return new NoOpConverter();
        }
        for (Converter converter : this.converters) {
            if (converter.canConvert(sourceValue) && converter.getTargetType() == dstType) {
                return converter;
            }
            if (!(converter instanceof BidirectionalConverter) || ((BidirectionalConverter)converter).getSourceType() != dstType || converter.getTargetType() != srcType) continue;
            return new ReverseConverter((BidirectionalConverter)converter);
        }
        return null;
    }

    public void register(Converter converter) {
        this.converters.add(converter);
    }

    private ConverterManager() {
        try {
            if (IOUtil.isURIAvailable(CUSTOM_SETUP_FILENAME)) {
                this.readConfigFile(CUSTOM_SETUP_FILENAME);
            } else {
                configLogger.debug((Object)"No custom converter setup 'converters.txt' found; using defaults.");
            }
            this.readConfigFile(DEFAULT_SETUP_FILENAME);
        }
        catch (IOException e) {
            throw new ConfigurationError("Error reading setup file: org/databene/commons/converter/converters.txt");
        }
    }

    private void readConfigFile(String filename) throws IOException {
        ReaderLineIterator iterator = new ReaderLineIterator(IOUtil.getReaderForURI(filename));
        while (iterator.hasNext()) {
            String className = iterator.next();
            BidirectionalConverter converter = (BidirectionalConverter)BeanUtil.newInstance(className);
            this.register(converter);
        }
        iterator.close();
    }
}

