/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.Date;
import java.util.TimeZone;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.AbstractBidirectionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date2LongConverter
extends AbstractBidirectionalConverter<Date, Long> {
    private TimeZone timeZone;

    public Date2LongConverter() {
        this(TimeZone.getDefault());
    }

    public Date2LongConverter(TimeZone timeZone) {
        super(Date.class, Long.class);
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Class<Long> getTargetType() {
        return Long.class;
    }

    @Override
    public Long convert(Date sourceValue) throws ConversionException {
        if (sourceValue == null) {
            return null;
        }
        return sourceValue.getTime() + (long)this.timeZone.getRawOffset();
    }

    @Override
    public Date revert(Long target) throws ConversionException {
        if (target == null) {
            return null;
        }
        return new Date(target - (long)this.timeZone.getRawOffset());
    }
}

