/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConversionException;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryConverter<S, T>
extends FixedSourceTypeConverter<S, T> {
    private static final Log logger = LogFactory.getLog(FactoryConverter.class);

    public FactoryConverter(Class<S> sourceType, Class<T> targetType) {
        super(sourceType, targetType);
    }

    @Override
    public T convert(S src) throws ConversionException {
        return (T)FactoryConverter.convert(src, this.targetType);
    }

    public static <TT> TT convert(Object src, Class<TT> targetType) throws ConversionException {
        if (src == null) {
            return null;
        }
        if (targetType.isAssignableFrom(src.getClass())) {
            return (TT)src;
        }
        TT result = FactoryConverter.tryToConstructByValueOfMethod(src, targetType);
        if (result == null) {
            result = FactoryConverter.tryToConstructByGetInstanceMethod(src, targetType);
        }
        if (result == null) {
            result = FactoryConverter.tryToConstructWithSourceParameter(src, targetType);
        }
        if (result == null) {
            result = FactoryConverter.tryToConstructByTypeValueMethod(src, targetType);
        }
        if (result == null) {
            throw new ConversionException("Don't know how to convert '" + src + "' to " + targetType);
        }
        return result;
    }

    private static <T> T tryToConstructWithSourceParameter(Object src, Class<T> targetType) {
        try {
            Constructor<T> constructor = targetType.getConstructor(src.getClass());
            return constructor.newInstance(src);
        }
        catch (NoSuchMethodException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No appropriate constructor found in " + src.getClass()));
            }
        }
        catch (InstantiationException e) {
            logger.debug((Object)("Failed to instantiate " + targetType + " by constructor " + targetType.getSimpleName() + '(' + src.getClass().getName() + ')' + e));
        }
        catch (IllegalAccessException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Constructor not visible");
            }
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)("Failed to instantiate " + targetType + " by constructor " + targetType.getSimpleName() + '(' + src.getClass().getName() + ')' + e));
        }
        return null;
    }

    private static <T> T tryToConstructByValueOfMethod(Object src, Class<T> targetType) {
        try {
            Method valueOfMethod = targetType.getMethod("valueOf", src.getClass());
            if ((valueOfMethod.getModifiers() & 8) == 0) {
                return null;
            }
            return (T)valueOfMethod.invoke(null, src);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T tryToConstructByGetInstanceMethod(Object src, Class<T> targetType) {
        try {
            Method valueOfMethod = targetType.getMethod("getInstance", src.getClass());
            if ((valueOfMethod.getModifiers() & 8) == 0) {
                return null;
            }
            return (T)valueOfMethod.invoke(null, src);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T tryToConstructByTypeValueMethod(Object src, Class<T> targetType) {
        try {
            String methodName = StringUtil.uncapitalize(targetType.getSimpleName()) + "Value";
            Method typeValueMethod = src.getClass().getMethod(methodName, new Class[0]);
            if ((typeValueMethod.getModifiers() & 8) == 8) {
                return null;
            }
            return (T)typeValueMethod.invoke(src, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

