/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaType {
    private static Map<String, JavaType> instancesByName = new HashMap<String, JavaType>();
    private static Map<Class<?>, JavaType> instancesByPrimitive = new HashMap();
    private static Map<Class<?>, JavaType> instancesByWrapper = new HashMap();
    private static Set<Class<? extends Number>> numberTypes = new HashSet<Class<? extends Number>>();
    public static final JavaType BOOLEAN = new JavaType("boolean", Boolean.TYPE, Boolean.class);
    public static final JavaType CHAR = new JavaType("char", Short.TYPE, Short.class);
    public static final JavaType BYTE = new JavaType("byte", Byte.TYPE, Byte.class);
    public static final JavaType SHORT = new JavaType("short", Short.TYPE, Short.class);
    public static final JavaType INT = new JavaType("int", Integer.TYPE, Integer.class);
    public static final JavaType LONG = new JavaType("long", Long.TYPE, Long.class);
    public static final JavaType FLOAT = new JavaType("float", Float.TYPE, Float.class);
    public static final JavaType DOUBLE = new JavaType("double", Double.TYPE, Double.class);
    public static final JavaType BIG_INT = new JavaType("big_int", BigInteger.class, BigInteger.class);
    public static final JavaType BIG_DECIMAL = new JavaType("big_decimal", BigDecimal.class, BigDecimal.class);
    private final String name;
    private final Class<?> primitiveClass;
    private final Class<?> wrapperClass;

    private JavaType(String name, Class<?> primitiveClass, Class<?> objectClass) {
        this.name = name;
        this.primitiveClass = primitiveClass;
        this.wrapperClass = objectClass;
        instancesByName.put(name, this);
        instancesByPrimitive.put(primitiveClass, this);
        instancesByWrapper.put(objectClass, this);
        if (Number.class.isAssignableFrom(this.wrapperClass)) {
            numberTypes.add(this.wrapperClass);
        }
        if (Number.class.isAssignableFrom(this.wrapperClass)) {
            numberTypes.add(primitiveClass);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperClass;
    }

    public static Collection<JavaType> getInstances() {
        return instancesByName.values();
    }

    public static JavaType getInstance(String name) {
        return instancesByName.get(name);
    }

    public static Class getWrapperClass(Class<?> numberType) {
        JavaType resultType = instancesByPrimitive.get(numberType);
        if (resultType == null) {
            resultType = instancesByWrapper.get(numberType);
        }
        return resultType != null ? resultType.getWrapperClass() : null;
    }

    public static Class getPrimitiveClass(Class<?> numberType) {
        JavaType resultType = instancesByWrapper.get(numberType);
        if (resultType == null) {
            resultType = instancesByPrimitive.get(numberType);
        }
        return resultType != null ? resultType.getPrimitiveClass() : null;
    }

    public static Set<Class<? extends Number>> getNumberTypes() {
        return numberTypes;
    }

    public static boolean isDecimalType(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> type = value.getClass();
        return type == Double.class || type == Float.class || type == BigDecimal.class;
    }
}

