/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;
import org.databene.commons.StringCharacterIterator;
import org.databene.commons.TimeUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralParser
extends FixedSourceTypeConverter<String, Object> {
    public LiteralParser() {
        super(String.class, Object.class);
    }

    @Override
    public Object convert(String sourceValue) throws ConversionException {
        return LiteralParser.parse(sourceValue);
    }

    public static Object parse(String text) {
        char c;
        if (text == null) {
            return null;
        }
        String trimmed = text.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        if ("true".equals(trimmed)) {
            return Boolean.TRUE;
        }
        if ("false".equals(trimmed)) {
            return Boolean.FALSE;
        }
        if (trimmed.startsWith("'") && trimmed.endsWith("'") || trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
            return trimmed;
        }
        for (int i = 0; i < text.length(); ++i) {
            c = text.charAt(i);
            if (c == ':' || c == '-' || c == 'T' || c == '.' || c >= '0' && c <= '9' || c == ' ' || c == '\t') continue;
            return text;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(trimmed);
        c = iterator.next();
        if (c == '-') {
            Object number = LiteralParser.parseNonNegativeNumber(iterator, true, false);
            return number != null ? number : text;
        }
        if (c >= '0' && c <= '9') {
            iterator.pushBack();
            Object tmp = LiteralParser.parseNonNegativeNumber(iterator, false, false);
            if (tmp != null) {
                return tmp;
            }
            tmp = LiteralParser.parseDate(trimmed);
            if (tmp != null) {
                return tmp;
            }
        }
        return trimmed;
    }

    private static Object parseDate(String trimmed) {
        StringCharacterIterator iterator = new StringCharacterIterator(trimmed);
        Long year = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (year == null || !iterator.hasNext() || iterator.next() != '-') {
            return null;
        }
        if (!iterator.hasNext()) {
            return null;
        }
        Long month = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (month == null || !iterator.hasNext() || iterator.next() != '-') {
            return null;
        }
        if (!iterator.hasNext()) {
            return null;
        }
        month = month - 1L;
        Long day = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (day == null || day == 0L) {
            return null;
        }
        if (!iterator.hasNext()) {
            return TimeUtil.date(year.intValue(), month.intValue(), day.intValue());
        }
        if (iterator.next() != 'T') {
            return null;
        }
        Long hours = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (hours == null || !iterator.hasNext() || iterator.next() != ':') {
            return null;
        }
        Long minutes = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (minutes == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return TimeUtil.date(year.intValue(), month.intValue(), day.intValue(), hours.intValue(), minutes.intValue(), 0, 0);
        }
        if (iterator.next() != ':') {
            return null;
        }
        Long seconds = LiteralParser.parseNonNegativeIntegerPart(iterator, true);
        if (seconds == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return TimeUtil.date(year.intValue(), month.intValue(), day.intValue(), hours.intValue(), minutes.intValue(), seconds.intValue(), 0);
        }
        if (iterator.next() != '.') {
            return null;
        }
        Double f = LiteralParser.parseFraction(iterator);
        if (f == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return TimeUtil.date(year.intValue(), month.intValue(), day.intValue(), hours.intValue(), minutes.intValue(), seconds.intValue(), (int)(f * 1000.0));
        }
        return trimmed;
    }

    private static Double parseFraction(StringCharacterIterator iterator) {
        Double p = null;
        Double base = 0.1;
        while (iterator.hasNext()) {
            char c = iterator.next();
            if (c >= '0' && c <= '9') {
                if (p == null) {
                    p = 0.0;
                }
            } else {
                iterator.pushBack();
                return p;
            }
            p = p + base * (double)(c - 48);
            base = base / 10.0;
        }
        return p;
    }

    private static Long parseNonNegativeIntegerPart(StringCharacterIterator iterator, boolean leadingZeros) {
        Long n = null;
        int c = 48;
        int digitCount = 0;
        while (iterator.hasNext()) {
            char c2 = iterator.next();
            c = c2;
            if (!Character.isDigit((int)c2)) break;
            ++digitCount;
            if (n == null) {
                n = 0L;
            }
            int d = c - 48;
            if (!leadingZeros && digitCount == 2 && n == 0L) {
                return null;
            }
            n = n * 10L + (long)d;
            c = -1;
        }
        if (c != -1) {
            iterator.pushBack();
        }
        return n;
    }

    private static Object parseNonNegativeNumber(StringCharacterIterator iterator, boolean negative, boolean leadingZeros) {
        Long n = LiteralParser.parseNonNegativeIntegerPart(iterator, leadingZeros);
        if (n == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            if (n > Integer.MAX_VALUE) {
                return negative ? -n.longValue() : n;
            }
            return negative ? -n.intValue() : n.intValue();
        }
        if (iterator.next() == '.') {
            if (!iterator.hasNext()) {
                return negative ? -((double)n.longValue()) : (double)n.longValue();
            }
        } else {
            return null;
        }
        double p = n.longValue();
        double base = 0.1;
        while (iterator.hasNext()) {
            char c = iterator.next();
            if (c >= '0' && c <= '9') {
                p += base * (double)(c - 48);
            } else {
                return null;
            }
            base /= 10.0;
        }
        return negative ? -p : p;
    }
}

