/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.text.MessageFormat;
import java.util.Locale;
import org.databene.commons.ConversionException;
import org.databene.commons.LocaleUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageConverter
extends FixedSourceTypeConverter<Object, String> {
    private String pattern;
    private Locale locale;
    private MessageFormat format;

    public MessageConverter() {
        this("{0}", LocaleUtil.getFallbackLocale());
    }

    public MessageConverter(String pattern, Locale locale) {
        super(Object.class, String.class);
        this.pattern = pattern;
        this.locale = locale;
        this.buildFormat();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.buildFormat();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.buildFormat();
    }

    @Override
    public String convert(Object sourceValue) throws ConversionException {
        Object[] tmp = sourceValue;
        if (tmp != null && !tmp.getClass().isArray()) {
            tmp = new Object[]{tmp};
        }
        return this.format.format(tmp);
    }

    private void buildFormat() {
        this.format = new MessageFormat(this.pattern, this.locale);
    }
}

