/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.text.NumberFormat;
import java.util.Locale;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Number2StringConverter
extends FixedSourceTypeConverter<Number, String> {
    private int minimumFractionDigits;
    private int maximumFractionDigits;

    public Number2StringConverter(int minimumFractionDigits, int maximumFractionDigits) {
        super(Number.class, String.class);
        this.minimumFractionDigits = minimumFractionDigits;
        this.maximumFractionDigits = maximumFractionDigits;
    }

    @Override
    public String convert(Number sourceValue) throws ConversionException {
        return Number2StringConverter.convert(sourceValue, this.minimumFractionDigits, this.maximumFractionDigits);
    }

    public static String convert(Number sourceValue, int minimumFractionDigits, int maximumFractionDigits) {
        NumberFormat format = NumberFormat.getInstance(Locale.US);
        format.setMinimumFractionDigits(minimumFractionDigits);
        format.setMaximumFractionDigits(maximumFractionDigits);
        return format.format(sourceValue);
    }
}

