/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.NumberToNumberConverter;
import org.databene.commons.converter.ToStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConverter<T>
extends FixedSourceTypeConverter<Number, T> {
    public NumberConverter(Class<T> targetType) {
        super(Number.class, targetType);
    }

    @Override
    public T convert(Number sourceValue) throws ConversionException {
        return (T)NumberConverter.convert(sourceValue, this.targetType);
    }

    public static <TT> TT convert(Number src, Class<TT> targetType) {
        if (String.class.equals(targetType)) {
            return (TT)ToStringConverter.convert(src, null);
        }
        if (Number.class.isAssignableFrom(targetType) || targetType.isPrimitive()) {
            return NumberToNumberConverter.convert(src, targetType);
        }
        throw new UnsupportedOperationException("Don't know how to convert " + src.getClass() + " to " + targetType);
    }
}

