/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import org.databene.commons.ConversionException;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.converter.AbstractBidirectionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatConverter
extends AbstractBidirectionalConverter<Number, String> {
    private static final String DEFAULT_DECIMAL_PATTERN = "";
    private static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    private static final String DEFAULT_NULL_STRING = "";
    private String pattern;
    private char decimalSeparator;
    private DecimalFormat format;
    private String nullString;

    public NumberFormatConverter() {
        this("");
    }

    public NumberFormatConverter(String pattern) {
        super(Number.class, String.class);
        this.setPattern(pattern);
        this.setDecimalSeparator('.');
        this.setNullString("");
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.format = new DecimalFormat(pattern);
        this.setDecimalSeparator(this.decimalSeparator);
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        DecimalFormatSymbols newSymbols = new DecimalFormatSymbols();
        newSymbols.setDecimalSeparator(decimalSeparator);
        this.format.setDecimalFormatSymbols(newSymbols);
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    @Override
    public String convert(Number sourceNumber) throws ConversionException {
        return sourceNumber != null ? this.format.format(sourceNumber) : this.nullString;
    }

    @Override
    public Number revert(String target) throws ConversionException {
        if (NullSafeComparator.equals(target, this.nullString)) {
            return null;
        }
        try {
            Number result = this.format.parse(target);
            return result;
        }
        catch (ParseException e) {
            throw new ConversionException("Error converting " + target);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.pattern + ']';
    }
}

