/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberToNumberConverter<S extends Number, T extends Number>
extends FixedSourceTypeConverter<S, T> {
    public NumberToNumberConverter(Class<S> sourceType, Class<T> targetType) {
        super(sourceType, targetType);
    }

    @Override
    public T convert(S sourceValue) throws ConversionException {
        return (T)NumberToNumberConverter.convert(sourceValue, this.targetType);
    }

    public static <TT extends Number> TT convert(Number src, Class<TT> targetType) {
        if (BigInteger.class.equals(targetType)) {
            return (TT)BigInteger.valueOf(src.longValue());
        }
        if (BigDecimal.class.equals(targetType)) {
            return (TT)BigDecimal.valueOf(src.doubleValue());
        }
        Class primitiveClass = JavaType.getPrimitiveClass(targetType);
        return (TT)((Number)NumberToNumberConverter.convertNumberToPrimitive(src, primitiveClass));
    }

    private static Object convertNumberToPrimitive(Number src, Class<?> targetType) {
        if (Integer.TYPE.equals(targetType)) {
            return src.intValue();
        }
        if (Byte.TYPE.equals(targetType)) {
            return src.byteValue();
        }
        if (Short.TYPE.equals(targetType)) {
            return src.shortValue();
        }
        if (Long.TYPE.equals(targetType)) {
            return src.longValue();
        }
        if (Float.TYPE.equals(targetType)) {
            return Float.valueOf(src.floatValue());
        }
        if (Double.TYPE.equals(targetType)) {
            return src.doubleValue();
        }
        throw new UnsupportedOperationException("Don't know how to convert '" + src + "' to " + targetType);
    }
}

