/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.databene.commons.IOUtil;
import org.databene.commons.LocaleUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResourceBundleConverter
extends FixedSourceTypeConverter<String, String> {
    private ResourceBundle bundle;
    private ResourceBundle.Control control = new UTF8Control();

    public PropertyResourceBundleConverter(String baseName, Locale locale) {
        super(String.class, String.class);
        this.bundle = PropertyResourceBundle.getBundle(baseName, locale, this.control);
    }

    @Override
    public String convert(String sourceValue) {
        return this.bundle.getString(sourceValue);
    }

    static class UTF8Control
    extends ResourceBundle.Control {
        UTF8Control() {
        }

        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream stream = IOUtil.getInputStreamForURI(resourceName, true);
            Charset utf8 = Charset.forName("UTF-8");
            return new PropertyResourceBundle(new InputStreamReader(stream, utf8));
        }

        public Locale getFallbackLocale(String baseName, Locale locale) {
            Locale fallback = LocaleUtil.getFallbackLocale();
            return fallback.equals(locale) ? null : fallback;
        }
    }
}

