/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.io.UnsupportedEncodingException;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConversionException;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.AbstractBidirectionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2ByteArrayConverter
extends AbstractBidirectionalConverter<String, byte[]> {
    private String encoding;

    public String2ByteArrayConverter() {
        this(SystemInfo.getFileEncoding());
    }

    public String2ByteArrayConverter(String encoding) {
        super(String.class, byte[].class);
        this.encoding = encoding;
    }

    @Override
    public byte[] convert(String sourceValue) throws ConversionException {
        try {
            return sourceValue.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    public String revert(byte[] target) throws ConversionException {
        try {
            return new String(target, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationError(e);
        }
    }
}

