/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.databene.commons.ConversionException;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2DateConverter<E extends Date>
extends FixedSourceTypeConverter<String, E> {
    private static final String MILLI = "yyyy-MM-dd'T'hh:mm:ss.SSS";
    private static final String SECONDS = "yyyy-MM-dd'T'hh:mm:ss";
    private static final String MINUTES = "yyyy-MM-dd'T'hh:mm";
    private static final String DATE = "y-M-d";

    public String2DateConverter() {
        this(Date.class);
    }

    public String2DateConverter(Class<E> targetType) {
        super(String.class, targetType);
    }

    @Override
    public E convert(String sourceValue) {
        return (E)String2DateConverter.convert(sourceValue, this.targetType);
    }

    public static <T extends Date> Date convert(String sourceValue, Class<T> targetType) {
        if (StringUtil.isEmpty(sourceValue)) {
            return null;
        }
        try {
            SimpleDateFormat format;
            if (sourceValue.indexOf(84) < 0) {
                format = new SimpleDateFormat(DATE);
            } else {
                switch (sourceValue.length()) {
                    case 10: {
                        format = new SimpleDateFormat(DATE);
                        break;
                    }
                    case 16: {
                        format = new SimpleDateFormat(MINUTES);
                        break;
                    }
                    case 19: {
                        format = new SimpleDateFormat(SECONDS);
                        break;
                    }
                    case 23: {
                        format = new SimpleDateFormat(MILLI);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a supported date format: " + sourceValue);
                    }
                }
            }
            Date simpleDate = format.parse(sourceValue);
            if (targetType == Date.class) {
                return simpleDate;
            }
            if (targetType == java.sql.Date.class) {
                return new java.sql.Date(simpleDate.getTime());
            }
            if (targetType == Timestamp.class) {
                return new Timestamp(simpleDate.getTime());
            }
            throw new UnsupportedOperationException("Not a supported target type: " + targetType);
        }
        catch (ParseException e) {
            throw new ConversionException(e);
        }
    }
}

