/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;
import org.databene.commons.converter.AbstractBidirectionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2EnumConverter<E extends Enum>
extends AbstractBidirectionalConverter<String, E> {
    private Class<E> enumClass;

    public String2EnumConverter(Class<E> enumClass) {
        super(String.class, enumClass);
        this.enumClass = enumClass;
    }

    @Override
    public E convert(String sourceValue) throws ConversionException {
        return String2EnumConverter.convert(sourceValue, this.enumClass);
    }

    @Override
    public String revert(E target) throws ConversionException {
        return String.valueOf(target);
    }

    public static <T extends Enum> T convert(String sourceValue, Class<T> enumClass) throws ConversionException {
        Enum[] enumConstants;
        if (sourceValue == null) {
            return null;
        }
        for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.toString().equals(sourceValue)) continue;
            return (T)enumConstant;
        }
        throw new ConversionException(enumClass + " does not have an instance of name " + sourceValue);
    }
}

