/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.databene.commons.ConversionException;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.AbstractBidirectionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2TimeConverter
extends AbstractBidirectionalConverter<String, Time> {
    private static final String MILLIS = "hh:mm:ss.SSS";
    private static final String SECONDS = "hh:mm:ss";
    private static final String MINUTES = "hh:mm";

    public String2TimeConverter() {
        super(String.class, Time.class);
    }

    @Override
    public Time convert(String sourceValue) throws ConversionException {
        return String2TimeConverter.parse(sourceValue);
    }

    public static Time parse(String sourceValue) throws ConversionException {
        if (StringUtil.isEmpty(sourceValue)) {
            return null;
        }
        try {
            SimpleDateFormat format;
            switch (sourceValue.length()) {
                case 12: {
                    format = new SimpleDateFormat(MILLIS);
                    break;
                }
                case 8: {
                    format = new SimpleDateFormat(SECONDS);
                    break;
                }
                case 5: {
                    format = new SimpleDateFormat(MINUTES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a supported time format: " + sourceValue);
                }
            }
            Date simpleDate = format.parse(sourceValue);
            long millis = simpleDate.getTime();
            return new Time(millis += (long)TimeZone.getDefault().getRawOffset());
        }
        catch (ParseException e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public String revert(Time target) throws ConversionException {
        return new SimpleDateFormat(MILLIS).format(new Date(target.getTime()));
    }
}

