/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.Date;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FactoryConverter;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.JavaType;
import org.databene.commons.converter.String2DateConverter;
import org.databene.commons.converter.String2EnumConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter<T>
extends FixedSourceTypeConverter<String, T> {
    public StringConverter(Class<T> targetType) {
        super(String.class, targetType);
    }

    @Override
    public T convert(String sourceValue) throws ConversionException {
        return StringConverter.convert(sourceValue, this.targetType);
    }

    public static <T> T convert(String src, Class<T> targetType) throws ConversionException {
        if (src == null) {
            return null;
        }
        if (src.length() == 0 && (Number.class.isAssignableFrom(targetType) || JavaType.getWrapperClass(targetType) != null)) {
            return null;
        }
        if (targetType == Character.TYPE || targetType == Character.class) {
            switch (src.length()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (T)Character.valueOf(src.charAt(0));
                }
            }
            throw new ConversionException("'" + src + "' cannot be converted to a character");
        }
        if (targetType.getEnumConstants() != null) {
            return String2EnumConverter.convert(src, targetType);
        }
        if (Date.class.isAssignableFrom(targetType)) {
            return (T)String2DateConverter.convert(src, targetType);
        }
        if (targetType.isArray()) {
            return (T)ArrayFormat.parse(src, ",", targetType.getComponentType());
        }
        T result = null;
        Class wrapperClass = JavaType.getWrapperClass(targetType);
        if (wrapperClass != null) {
            result = (T)FactoryConverter.convert(src, wrapperClass);
        }
        if (result != null) {
            return result;
        }
        result = FactoryConverter.convert(src, targetType);
        if (result != null) {
            return result;
        }
        throw new UnsupportedOperationException("Don't know how to convert '" + src + "' to " + targetType);
    }
}

