/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.lang.reflect.Array;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubArrayExtractor
extends FixedSourceTypeConverter<Object[], Object[]> {
    private int[] indexes;

    public SubArrayExtractor(int ... indexes) {
        super(Object[].class, Object[].class);
        this.indexes = indexes;
    }

    @Override
    public Object[] convert(Object[] sourceValue) throws ConversionException {
        Class<?> componentType = sourceValue.getClass().getComponentType();
        Object[] array = (Object[])Array.newInstance(componentType, this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            array[i] = sourceValue[this.indexes[i]];
        }
        return array;
    }
}

