/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;

public class ToArrayConverter
extends FixedSourceTypeConverter {
    private Class componentType;
    private boolean nullToEmpty;

    public ToArrayConverter() {
        this(Object.class);
    }

    public ToArrayConverter(Class componentType) {
        this(componentType, true);
    }

    public ToArrayConverter(Class componentType, boolean nullToEmpty) {
        super(Object.class, ArrayUtil.arrayType(componentType));
        this.componentType = componentType;
        this.nullToEmpty = nullToEmpty;
    }

    public void setNullToEmpty(boolean nullToEmpty) {
        this.nullToEmpty = nullToEmpty;
    }

    public Object convert(Object sourceValue) {
        return ToArrayConverter.convert(sourceValue, this.componentType, this.nullToEmpty);
    }

    public static Object convert(Object sourceValue, Class componentType) {
        return ToArrayConverter.convert(sourceValue, componentType, true);
    }

    public static Object convert(Object sourceValue, Class componentType, boolean nullToEmpty) {
        if (sourceValue == null) {
            return nullToEmpty ? ArrayUtil.buildArrayOfType(componentType, new Object[0]) : null;
        }
        if (sourceValue instanceof Collection) {
            Collection col = (Collection)sourceValue;
            Object[] array = (Object[])Array.newInstance(componentType, col.size());
            int count = 0;
            for (Object item : col) {
                array[count++] = item;
            }
            return array;
        }
        if (componentType == Byte.TYPE) {
            Method method = BeanUtil.getMethod(sourceValue.getClass(), "getBytes", new Class[0]);
            if (method != null) {
                return (byte[])BeanUtil.invoke(sourceValue, method, new Object[0]);
            }
            throw new UnsupportedOperationException("Conversion not supported: " + sourceValue.getClass() + " -> " + componentType + "[]");
        }
        if (sourceValue.getClass().isArray()) {
            return ArrayUtil.buildArrayOfType(componentType, (Object[])sourceValue);
        }
        return ArrayUtil.buildArrayOfType(componentType, sourceValue);
    }
}

