/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.Collection;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToCollectionConverter<C extends Collection>
extends FixedSourceTypeConverter<Object, C> {
    public ToCollectionConverter(Class<C> targetType) {
        super(Object.class, targetType);
    }

    @Override
    public C convert(Object sourceValue) throws ConversionException {
        return (C)ToCollectionConverter.convert(sourceValue, this.targetType);
    }

    public static Collection convert(Object sourceValue, Class targetType) {
        if (sourceValue == null) {
            return null;
        }
        if (sourceValue.getClass() == targetType) {
            return (Collection)sourceValue;
        }
        Object collection = CollectionUtil.newInstance(targetType);
        if (sourceValue instanceof Collection) {
            collection.addAll((Collection)sourceValue);
        } else if (sourceValue.getClass().isArray()) {
            Object[] array;
            for (Object o : array = (Object[])sourceValue) {
                collection.add((Object)o);
            }
        } else {
            collection.add((Object)sourceValue);
        }
        return collection;
    }
}

