/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.databene.commons.ArrayFormat;
import org.databene.commons.Base64Codec;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.JavaType;
import org.databene.commons.converter.NumberFormatConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringConverter
extends FixedSourceTypeConverter<Object, String> {
    private static final String DEFAULT_NULL_STRING = "";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private String nullString;
    private String datePattern;
    private String timestampPattern;
    private NumberFormatConverter decimalConverter;

    public ToStringConverter() {
        this(DEFAULT_NULL_STRING);
    }

    public ToStringConverter(String nullString) {
        this(nullString, DEFAULT_DATE_PATTERN, DEFAULT_TIMESTAMP_PATTERN);
    }

    public ToStringConverter(String nullString, String datePattern, String timestampPattern) {
        super(Object.class, String.class);
        this.nullString = nullString;
        this.datePattern = datePattern;
        this.timestampPattern = timestampPattern;
        this.decimalConverter = null;
    }

    @Deprecated
    public String getNullResult() {
        return this.getNullString();
    }

    @Deprecated
    public void setNullResult(String nullResult) {
        this.setNullString(nullResult);
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullResult) {
        this.nullString = nullResult;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public String getDecimalPattern() {
        return this.decimalConverter.getPattern();
    }

    public void setDecimalPattern(String decimalPattern) {
        if (this.decimalConverter == null) {
            this.decimalConverter = new NumberFormatConverter(decimalPattern);
        }
        this.decimalConverter.setPattern(decimalPattern);
    }

    public char getDecimalSeparator() {
        return this.decimalConverter.getDecimalSeparator();
    }

    public void setDecimalSeparator(char decimalSeparator) {
        if (this.decimalConverter == null) {
            this.decimalConverter = new NumberFormatConverter();
        }
        this.decimalConverter.setDecimalSeparator(decimalSeparator);
    }

    @Override
    public String convert(Object source) throws ConversionException {
        return ToStringConverter.convert(source, this.nullString, this.datePattern, this.timestampPattern, this.decimalConverter);
    }

    public static <TT> String convert(TT source, String nullString) {
        return ToStringConverter.convert(source, nullString, null, null, null);
    }

    public static <TT> String convert(TT source, String nullString, String datePattern, String timestampPattern, NumberFormatConverter decimalConverter) {
        if (source == null) {
            return nullString;
        }
        if (source instanceof String) {
            return (String)source;
        }
        if (decimalConverter != null && JavaType.isDecimalType(source)) {
            return decimalConverter.convert((Number)source);
        }
        if (source.getClass().isArray()) {
            Class<?> componentType = source.getClass().getComponentType();
            if (componentType == Byte.TYPE) {
                return Base64Codec.encode((byte[])source);
            }
            if (componentType == Character.TYPE) {
                return String.valueOf((char[])source);
            }
            return ArrayFormat.format((Object[])source);
        }
        if (source instanceof Class) {
            return ((Class)source).getName();
        }
        if (source instanceof Timestamp) {
            if (timestampPattern != null) {
                return new SimpleDateFormat(timestampPattern).format((Date)source);
            }
            return new SimpleDateFormat().format((Date)source);
        }
        if (source instanceof Date) {
            if (datePattern != null) {
                return new SimpleDateFormat(datePattern).format((Date)source);
            }
            return new SimpleDateFormat().format((Date)source);
        }
        return source.toString();
    }
}

