/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.converter;

import java.util.HashSet;
import java.util.Set;
import org.databene.commons.ConversionException;
import org.databene.commons.converter.FixedSourceTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueStringConverter
extends FixedSourceTypeConverter<String, String> {
    private static final int MAX_TRIES = 10000;
    private Set<String> usedStrings = new HashSet<String>();

    public UniqueStringConverter() {
        super(String.class, String.class);
    }

    @Override
    public String convert(String sourceValue) throws ConversionException {
        String resultValue = sourceValue;
        if (this.usedStrings.contains(sourceValue)) {
            boolean ok = false;
            for (int i = 0; !ok && i < 10000; ++i) {
                resultValue = sourceValue + i;
                if (this.usedStrings.contains(resultValue)) continue;
                ok = true;
            }
            if (!ok) {
                throw new UnsupportedOperationException("not more than 10000 identical Strings can be made unique");
            }
        }
        this.usedStrings.add(resultValue);
        return resultValue;
    }
}

